﻿var dataTables = {
    itemDisplayMode: { selected: "selected", alwaysWithRows: "alwaysWithRows", always: "always" },
    filterDisplayMode: { buttons: "buttons", dropdown: "dropdown" },
    callServerMethod: function (action, data, onSuccess, onError, additionalSettings) {
        var args = '';
        if (data !== undefined && data !== null) {
            args = data
        }

        var settings = additionalSettings || {};
        settings.type = settings.type || "POST";
        settings.url = action;
        settings.data = settings.data || JSON.stringify(args);
        settings.contentType = settings.contentType || "application/json; charset=utf-8";
        settings.dataType = settings.dataType || "json";
        settings.success = onSuccess;
        settings.error = onError;

        if (typeof seutil == "object")
            settings.headers = seutil.getHeaders();

        return $.ajax(settings);
    }
};

(function ($) {
    var dataTableConstants = {
        maxFilterLength: 6,
        maxToolBarLength: 6,
        animationsDuration: 200,
        blockElementTimeout: 800
    }

    $.widget("a4.sedatatable", {
        options: {
            generateTableStructure: false,
            title: undefined,
            serverSide: true,
            ajaxAction: undefined,
            ajaxParams: {},
            data: [],
            columns: [],
            defaultSorting: [],
            quickFilter: undefined,
            localizableTexts: [],
            allowRowSelection: false,
            rememberRowSelection: false,
            limitRowSelection: undefined,
            selectedRows: undefined,
            displayColumnSelector: false,
            displaySearchBox: true,
            advancedFilter: false,
            displayEmptyTopContainer: false,
            customStyle: "",
            displayLength: undefined,
            lengthMenu: [10, 25, 50, 100],
            isMobile: false,
            dataSplitChar: ','
        },
        _create: function () {
            var self = this;
            var opt = self.options;

            //Initializing container for methods that run before datatable is initialized
            this.container = this.element;

            this._initializeColumns();

            var table = this._renderTable();
            var tableDom = this._generateTableDom();
            var loadDataCall = null;
            var lengthMenu = opt.lengthMenu;

            this.updatedRows = [];

            if (opt.displayLength && _.isNumber(opt.displayLength)) {
                lengthMenu.push(opt.displayLength);
                lengthMenu.sort(function (a, b) { return a - b });
                lengthMenu = _.uniq(lengthMenu, true);
                pageLength = opt.displayLength;
            }

            //This object will be used in loadServerData. It will be merged with the filter params if a filter is applied.
            //A clone is needed to not mess with the parameters specified by the user.
            this.ajaxParams = _.clone(opt.ajaxParams);

            this.dataTable = table.DataTable({
                "pagingType": "full_numbers",
                "searching": opt.displaySearchBox,
                "processing": false,
                "deferRender": true,
                "serverSide": opt.serverSide,
                "data": opt.data,
                "ajax": function (data, callback, settings) {
                    if (opt.serverSide) {
                        loadDataCall = self._loadServerData(data, callback, settings);
                    }
                },
                "drawCallback": function (settings) {
                    var pageInfo = this.api().page.info();

                    $(".h-selectAll", this.container).prop("checked", false);

                    self._checkSelectedRowsLimit();

                    $(".dataTables_paginate", this.container).toggle(pageInfo.pages > 1);

                    self._trigger("draw", null, { totalRecords: pageInfo.recordsTotal });
                },
                "createdRow": function (row, data, dataIndex) {
                    if (opt.rememberRowSelection && self.keyColumn && self.selectedRows && _.some(self.selectedRows, function (row) { return row[self.keyColumn] == data[self.keyColumn] })) {
                        $(row).addClass("selected");
                        $(row).find(".selectRow").attr("checked", "checked").prop("checked", true);

                        // Remove previous data and add row data
                        self.selectedRows = _.reject(self.selectedRows, function (item) { return item[self.keyColumn] == data[self.keyColumn]; });
                        self.selectedRows.push(data);

                        if (opt.isMobile) {
                            var uiCheckox = $(row).find(".ui-checkbox");
                            uiCheckox.find("label").removeClass("ui-checkbox-off").addClass("ui-checkbox-on");
                            uiCheckox.find("span.ui-icon").removeClass("ui-icon-checkbox-off").addClass("ui-icon-checkbox-on");
                        }
                    }

                    self._trigger("rowCreated", null, { index: dataIndex, row: row, data: data });
                },
                "columns": self.columns,
                "order": opt.defaultSorting,
                "orderClasses": true,
                "language": self._getDataTableLocalizableTexts(),
                "dom": tableDom,
                "autoWidth": false,
                "pageLength": opt.displayLength,
                "lengthMenu": lengthMenu
            });

            //Updating container with the datatables container
            this.container = this.dataTable.table().container();

            this._renderAdvancedFilterToggleButton();
            this._renderColumnSelector();
            this._renderQuickFilter();

            $(".dataTables_filter", this.wrapper).append($("<span />", { "class": "h-filterButton filter-button" }));
            $(".dataTables_filter :input", this.wrapper).attr("placeholder", this._getLocalizableText("Search"));

            this._bindEvents();
            this._initializeSelectedRows();

            $(this.container).addClass(["se-datatable", opt.customStyle].join(" "));

            if (opt.serverSide || !opt.data || opt.data.length == 0) {
                $('.toolBar .button', this.container).hide();
                $(".dataTables_paginate", this.container).hide();
            }

            if (opt.serverSide) {
                //Hide table to prevent flickering
                $(".dataTables-content", this.container).hide();
                $(".dataTables-message", this.container).show();

                //Waiting for the initialization calls to complete to display the table
                $.when(loadDataCall).then(function () {
                    $(".dataTables-content", self.container).show("blind", "swing", dataTableConstants.animationsDuration);
                    $(".dataTables-message", self.container).hide();
                }, function () {
                    $(".dataTables-message", self.container).addClass("error-message").html(self._getLocalizableText("UnexpectedError"));
                    self.hasError = true;
                });
            }

            //Switching header row with advanced filter row
            if (opt.advancedFilter) {
                $("thead tr.header-row", this.container).after($("thead tr.advanced-filter", this.container));
            }

            //Render title
            if (opt.title) {
                $(".title", this.container).html(opt.title);
            }
        },
        _loadServerData: function (data, callback, settings) {
            var self = this;
            var ajaxParams = { tableParams: this._getTableParams(data) };

            if (this.ajaxParams) {
                ajaxParams = _.extend(ajaxParams, this.ajaxParams);
            }

            return dataTables.callServerMethod(this.options.ajaxAction, ajaxParams,
            function (result) {
                if (result) {
                    if (result.d) {
                        result = _.isString(result.d) ? JSON.parse(result.d) : result.d;
                    }

                    self.additionalData = result.additionalData;
                    callback(result);

                    if (self.options.isMobile) {
                        var table = $("table", self.container);
                        table.table("refresh");
                    }
                }

                if (self.hasError) {
                    $(".dataTables-content", self.container).show();
                    $(".dataTables-message", self.container).hide();
                    self.hasError = false;
                }
            },
            function (error) {
                var message = "";

                try {
                    message = error.status == 404 ? error.statusText : eval("(" + error.responseText + ")").Message;
                }
                catch (ex) { }

                self.hasError = true;
                $(".dataTables-content", self.container).hide();
                $(".dataTables-message", self.container).addClass("error-message").html(message).show();

                self._trigger("error", null, { message: message });
            }, { blockElement: $(settings.nTable), blockElementTimeout: dataTableConstants.blockElementTimeout });
        },
        _setOption: function (key, value) {
            var options = this.options;
            switch (key) {
                case "ajaxParams":
                    if (!options.ajaxParams) {
                        options.ajaxParams = {};
                    }
                    //Merge with the user specified params
                    options.ajaxParams = _.extend(options.ajaxParams, value);

                    if (!this.ajaxParams) {
                        this.ajaxParams = {};
                    }
                    //Merge with the current grid params (user specified + filter params)
                    this.ajaxParams = _.extend(this.ajaxParams, value);
                    break;
                case "selectedRows":
                    options.selectedRows = value;
                    this._initializeSelectedRows();
                    this.refresh();
                    break;
                case "data":
                    options.data = value;
                    this.dataTable.clear();
                    this.dataTable.rows.add(options.data).draw();
                    break;
            }
        },
        destroy: function () {
            this.dataTable.destroy();
            $.Widget.prototype.destroy.call(this);
        },
        _getDataTableLocalizableTexts: function () {
            return {
                lengthMenu: this._getLocalizableText("LengthMenu"),
                emptyTable: this._getLocalizableText("EmptyTable"),
                info: this._getLocalizableText("Info"),
                infoEmpty: this._getLocalizableText("InfoEmpty"),
                infoFiltered: this._getLocalizableText("InfoFiltered"),
                zeroRecords: this._getLocalizableText("ZeroRecords"),
                paginate: { "first": "<<", "previous": "<", "next": ">", "last": ">>" },
                search: "",
                loadingRecords: "",
                processing: ""
            };
        },
        _getLocalizableText: function (key) {
            var text = undefined;

            if (this.options.localizableTexts[key]) {
                text = this.options.localizableTexts[key];
            }
            else if (dataTableResources && dataTableResources[key]) {
                text = dataTableResources[key];
            }
            else if (sharedResources && sharedResources[key]) {
                text = sharedResources[key];
            }

            return text;
        },
        _initializeColumns: function () {
            var columns = [];
            var self = this;

            //Select row column
            if (this.options.allowRowSelection) {
                var chkbox = "<input type='checkbox' class='selectRow' title='" + this._getLocalizableText("SelectRow") + "'>";

                columns.push({
                    name: "SelectRow",
                    data: null,
                    defaultContent: self.options.isMobile ?
                        "<div class='ui-checkbox'>" + chkbox + "<label class='choiceText ui-first-child ui-checkbox-off ui-fullsize ui-btn-icon-left' data-corners='true' data-shadow='false' data-iconshadow='true' data-wrapperels='span' data-icon='checkbox-on' data-theme='c' data-mini='false'><span class='ui-btn-inner'><span class='ui-btn-text'></span><span class='ui-icon ui-icon-checkbox-off ui-icon-shadow'>&nbsp;</span></span></div>" :
                        chkbox,
                    width: "25px",
                    orderable: false,
                    searchable: false,
                    isDataColumn: false
                });
            }

            _.each(this.options.columns, function (col) {
                columns.push(self._createColumn(col));
            });

            if (this.options.advancedFilter) {
                columns.push({
                    name: "AdvancedFilterMenu",
                    data: null,
                    defaultContent: "",
                    width: "42px",
                    orderable: false,
                    searchable: false,
                    isDataColumn: false
                });
            }

            this.columns = columns;

            return columns;
        },
        _createColumn: function (column) {
            var dataTableColumn = {};
            var sortable = (column.Sortable === undefined || column.Sortable) && !column.Index;
            var cssClass;
            var options = this.options;

            cssClass = "value-column";

            if (column.Class) {
                cssClass += " " + column.Class;
            }

            if (column.Name === undefined && column.Data !== undefined) {
                column.Name = column.Data;
            }
            else if (column.Data === undefined && column.Name !== undefined) {
                column.Data = column.Name;
            }

            dataTableColumn.title = (column.Title || " "); //"<span class='column-title'>" + (column.Title || " ") + "</span>" + (sortable ? "<span class='icon-small'></span>" : "");
            dataTableColumn.width = column.Width;
            dataTableColumn.type = column.Type;
            dataTableColumn.orderable = sortable;
            dataTableColumn.searchable = (column.Searchable === undefined || column.Searchable !== false) && this._isVisibleColumn(column);
            dataTableColumn.orderData = column.DataSort;
            dataTableColumn.visible = this._isVisibleColumn(column);
            dataTableColumn.className = cssClass;
            dataTableColumn.data = column.Data;
            dataTableColumn.name = column.Name;
            dataTableColumn.defaultContent = column.DefaultValue;

            if (column.Editable) {
                dataTableColumn.render = function (data, type, row, meta) {
                    if (type == "display") {
                        var input = "<input />";
                        var inputAttributes = { "data-dataproperty": column.Data };

                        if (column.Type) {
                            inputAttributes["data-type"] = column.Type;
                        }

                        inputAttributes["class"] = "editable";

                        if (column.Type == "boolean") {
                            inputAttributes["type"] = "checkbox";

                            if (data) {
                                inputAttributes["checked"] = "checked";
                            }
                        }
                        else if (column.Type == "richtext") {
                            input = "<div />";

                            if (data) {
                                inputAttributes["html"] = data;
                            }

                            inputAttributes["class"] += " v-qeRichEditText";
                        }
                        else {
                            inputAttributes["type"] = "text";

                            if (data) {
                                inputAttributes["value"] = data;
                            }
                        }

                        return $(input, inputAttributes)[0].outerHTML;
                    }
                    else {
                        return data;
                    }
                }
            }
            else if (column.Label) {
                dataTableColumn.render = function (data, type, row, meta) {
                    return row[column.Label];
                }
            }
            else if (column.Prefix || column.Suffix) {
                dataTableColumn.render = function (data, type, row, meta) {
                    if (data) {
                        return (column.Prefix || "") + data + (column.Suffix || "");
                    }

                    return "";
                }
            }

            if (column.Index && !dataTableColumn.data) {
                dataTableColumn.data = function (row, type, set, meta) {
                    var index = meta.row + 1;

                    if (options.serverSide) {
                        index += meta.settings._iDisplayStart;
                    }

                    row.Index = index;

                    return index;
                };
            }

            if (column.Key) {
                this.keyColumn = column.Name;
            }

            //Aditional properties
            dataTableColumn.IsDataColumn = true;
            dataTableColumn.HideInSelector = column.HideInSelector;
            dataTableColumn.AdvancedFilter = column.AdvancedFilter;
            dataTableColumn.AdvancedFilterLabels = column.AdvancedFilterLabels;
            dataTableColumn.EnumType = column.EnumType;

            return dataTableColumn;
        },
        _getColumnByName: function (name) {
            return _.find(this.columns, function (column) { return column.name == name });
        },
        _isVisibleColumn: function (column) {
            return (column.Visible === undefined || column.Visible !== false);
        },
        _renderTable: function () {
            var table = this.container;
            var style = this.options.customStyle || "";
            var columns = this.columns;
            var self = this;

            if (this.options.generateTableStructure) {
                table = $("<table />", { "class": style, "data-role": "table", "data-mode": "reflow" });

                var tableHead = $("<thead />");

                self._renderAdvancedFilterRow(tableHead);

                //Render header row
                var headerRow = $("<tr />", { "class": "header-row" });

                _.each(columns, function (column, index) {
                    var cell = $("<th />", { "data-column-name": column.Name });

                    if (index == 0 && self.options.allowRowSelection && !self.options.limitRowSelection) {
                        cell.append($("<input />", { "type": "checkbox", "class": "h-selectAll", "title": self._getLocalizableText("SelectAllRows") }));
                    }

                    headerRow.append(cell);
                });

                //Render content row
                tableHead.append(headerRow);

                var tableBody = $("<tbody />");
                var contentRow = $("<tr />");

                _.each(columns, function (column) {
                    contentRow.append($("<td />"));
                });

                tableBody.append(contentRow);

                table.append(tableHead);
                table.append(tableBody);

                this.container.append(table);
            }
            else {
                if (this.options.advancedFilter) {
                    this._renderAdvancedFilterRow($("thead", this.container));
                }
                else {
                    $("th.advanced-filter, td.advanced-filter", this.container).detach();
                }
            }

            return table;
        },
        _generateTableDom: function () {
            var filterSection = "";
            var columnSelector = "";
            var advancedFilterToggleButton = "";
            var toolBar = "";
            var filter = "";
            var top = "";
            var hasTop = this.options.displayEmptyTopContainer;
            var tableContent = "";

            if (this.options.displaySearchBox) {
                filterSection = 'f';
                hasTop = true;
            }

            if (this.options.displayColumnSelector) {
                columnSelector = '<"column-selector">';
                hasTop = true;
            }

            if (this.options.advancedFilter) {
                advancedFilterToggleButton = '<"advanced-filter-toggle">';
                hasTop = true;
            }

            if (this.options.quickFilter) {
                filter = '<"filter-bar">';
                hasTop = true;
            }

            if (hasTop) {
                top = '<"top clearfix"' + filter + toolBar + columnSelector + advancedFilterToggleButton + filterSection + '>'
            }

            tableContent = '<"dataTables-content" ' + top + 't<"bottom clearfix no-print"i<"v-selectedRows selected-rows">pl>>';

            if (this.options.serverSide) {
                tableContent += '<"dataTables-message"<"loading-icon">>';
            }

            return tableContent;
        },
        _renderQuickFilter: function () {
            var filter = $(".filter-bar", this.container);

            if (filter.length > 0) {
                var filterItems = this.options.quickFilter.Items;
                var filterItemsLength = filterItems.length + 1 + (this.options.quickFilter.IncludeSelectedStates ? 2 : 0);

                var buttonGroup = $("<div />", { "class": "button-group" });

                if ((this.options.quickFilter.DisplayMode == undefined && filterItemsLength <= dataTableConstants.maxFilterLength) || this.options.quickFilter.DisplayMode == dataTables.filterDisplayMode.buttons) {
                    filter.addClass("buttons");

                    buttonGroup.append($("<div />", { "class": "button selected" }).append(this._getLocalizableText("All")));

                    if (this.options.quickFilter.IncludeSelectedStates) {
                        buttonGroup.append($("<div />", { "class": "button v-selected" }).append(this._getLocalizableText("Selected")));
                        buttonGroup.append($("<div />", { "class": "button v-notSelected" }).append(this._getLocalizableText("NotSelected")));
                    }

                    for (var i = 0; i < filterItems.length; i++) {
                        var button = $("<div class='button'>").append(filterItems[i].Label).attr("data-index", i);
                        buttonGroup.append(button);
                    };
                }
                else {
                    filter.addClass("dropdown");

                    buttonGroup.append($("<div />", { "class": "button icon-only dropdown-toggle" }).append($("<span />", { "class": "icon filter" })).append($("<span />", { "class": "label", "text": this._getLocalizableText("All") })).append($("<span />", { "class": "icon-small down-arrow-black" })));

                    var menuItems = $("<ul />", { "class": "dropdown-menu left-align" });

                    menuItems.append($("<li />", { "class": "selected" }).append($("<a />", { "text": this._getLocalizableText("All") })));

                    if (this.options.quickFilter.IncludeSelectedStates) {
                        buttonGroup.append($("<li />", { "class": "v-selected" }).append($("<a />", { "text": this._getLocalizableText("Selected") })));
                        buttonGroup.append($("<li />", { "class": "v-notSelected" }).append($("<a />", { "text": this._getLocalizableText("NotSelected") })));
                    }

                    for (var i = 0; i < filterItems.length; i++) {
                        menuItems.append($("<li />", { "data-index": i }).append($("<a />", { "text": filterItems[i].Label })));
                    }

                    buttonGroup.append(menuItems);
                }

                filter.append(buttonGroup);
            }
        },
        _generateEnumFilterCondition: function (enumType) {
            var enumType = EnumDetails[enumType];
            var dropDown = $("<select />", {});

            dropDown.append($("<option />", { "value": null }));

            _.each(enumType, function (e) {
                dropDown.append($("<option />", { "value": e.Value }).append(e.Label));
            });

            return dropDown;
        },
        _generateBoolFilterCondition: function (labels) {
            var dropDown = $("<select />", {});
            var trueLabel, falseLabel;

            if (labels) {
                trueLabel = labels["1"];
                falseLabel = labels["0"];
            }
            else {
                trueLabel = this._getLocalizableText("Yes");
                falseLabel = this._getLocalizableText("No");
            }

            dropDown.append($("<option />", { "value": null }));
            dropDown.append($("<option />", { "value": 1 }).append(trueLabel));
            dropDown.append($("<option />", { "value": 0 }).append(falseLabel));

            return dropDown;
        },
        _generateDateTimeFilterCondition: function () {
            var div = $("<div />", { "class": "date-filter" });

            div.append($("<input />", { "type": "text", "class": "v-fromDate", "placeholder": this._getLocalizableText("From") }).datetimepicker());
            div.append($("<input />", { "type": "text", "class": "v-toDate", "placeholder": this._getLocalizableText("To") }).datetimepicker());

            return div;
        },
        _renderAdvancedFilterRow: function (header) {
            if (this.options.advancedFilter) {
                var self = this;
                var advancedFilterRow = $("<tr />", { "class": "advanced-filter" });

                _.each(this.columns, function (column) {
                    var filterColumn = $("<th />", { "class": "advanced-filter-column" });

                    if (column.IsDataColumn && (column.AdvancedFilter === undefined || column.AdvancedFilter === true)) {
                        filterColumn.attr("data-column", column.name);

                        var columnType = (column.type !== undefined ? column.type : "text").toLowerCase();

                        if (columnType == "enum" && EnumDetails !== undefined) {
                            filterColumn.append(self._generateEnumFilterCondition(column.EnumType));
                        }
                        else if (columnType == "boolean") {
                            filterColumn.append(self._generateBoolFilterCondition(column.AdvancedFilterLabels));
                        }
                        else if (columnType == "date" || columnType == "datetime") {
                            filterColumn.append(self._generateDateTimeFilterCondition());
                        }
                        else {
                            var input = $("<input />", { "type": "text" });
                            if (columnType == "numeric") {
                                input.autoNumeric({ aSep: '', aDec: '.', aPad: false });
                            }
                            filterColumn.append(input);
                        }
                    }

                    advancedFilterRow.append(filterColumn);
                });

                var clearButton = $("<div />", { "class": "h-clearAdvancedFilter sprite-icons img-cancel", "title": this._getLocalizableText("ClearFilter") });
                var refreshButton = $("<div />", { "class": "h-applyAdvancedFilter sprite-icons img-confirm", "title": this._getLocalizableText("ApplyFilter") });

                $("th:last", advancedFilterRow).append(refreshButton).append(clearButton);

                header.prepend(advancedFilterRow);
            }
        },
        _bindEvents: function () {
            var self = this;
            var dataTable = this.dataTable;
            var options = this.options;

            if (options.allowRowSelection) {
                dataTable.on("change", "tr .selectRow", function () {
                    var table = $(this).closest(".dataTable");
                    var isChecked = $(this).is(":checked");
                    var row = $(this).closest("tr");
                    var rowData = dataTable.row(row).data();

                    table.find(".h-selectAll").prop("checked", false);
                    self._updateSelectedRows(rowData, isChecked);
                    self._setSelectedRowsLabel();
                    self._checkSelectedRowsLimit();

                    row.toggleClass("selected", isChecked);
                    $(".sprite-icons", row).toggleClass('inverted', isChecked);
                    self._trigger("selectRow", null, { row: row, data: rowData, isChecked: isChecked });
                });

                dataTable.on("click", "tr td .ui-checkbox", function () {
                    var label = $(this).find("label");
                    var isChecked = label.hasClass("ui-checkbox-on");
                    var oldClass = isChecked ? "ui-checkbox-on" : "ui-checkbox-off";
                    var newClass = isChecked ? "ui-checkbox-off" : "ui-checkbox-on";

                    label.removeClass(oldClass).addClass(newClass);
                    $(this).find("span.ui-icon").removeClass(oldClass.replace("ui-", "ui-icon-")).addClass(newClass.replace("ui-", "ui-icon-"));

                    var row = $(this).closest("tr");
                    var rowData = dataTable.row(row).data();

                    self._updateSelectedRows(rowData, !isChecked);
                    self._setSelectedRowsLabel();
                    self._checkSelectedRowsLimit();

                    if (isChecked)
                        row.removeClass('selected');
                    else
                        row.addClass('selected');

                    self._trigger("selectRow", null, { row: row, data: rowData, isChecked: !isChecked });
                });

                dataTable.on("change", ".h-selectAll", function () {
                    var rows = $(this).closest(".dataTable").find("tbody tr");
                    var rowsData = dataTable.rows({ page: "current" }).data();

                    if ($(".dataTables_empty", rows).length == 0) {
                        var isChecked = $(this).is(":checked");
                        rows.toggleClass("selected", isChecked);
                        $(".sprite-icons", rows).toggleClass('inverted', isChecked);

                        _.each(rowsData, function (value) { self._updateSelectedRows(value, isChecked); });
                        self._setSelectedRowsLabel();

                        $(".selectRow", rows).prop("checked", isChecked);
                        self._trigger("selectAll", null, { rows: rows, data: rowsData, isChecked: isChecked });
                    }
                });
            }

            if (options.quickFilter) {
                $("div.filter-bar.buttons .button, div.filter-bar.dropdown li", this.container).on("click", function () {
                    if (!$(this).hasClass("selected")) {
                        var container = $(this).closest(".button-group");

                        $(".selected", container).removeClass("selected");
                        $(this).addClass("selected");

                        var filterIndex = $(this).attr("data-index");
                        self._applyFilter(filterIndex);

                        $(".dropdown-toggle .label", container).text($(this).text());
                    }
                });
            }

            if (this.options.displayColumnSelector) {
                $(".column-selector li :checkbox", this.container).on("change", function () {
                    var check = !$(this).is(":checked");
                    $(this).prop("checked", check);
                    self.toggleColumn($(this).closest("li").attr("data-column-name"), check);
                });

                $(".column-selector li", this.container).on("click", function () {
                    var checkbox = $(this).find(":checkbox");
                    checkbox.trigger("change");
                });
            }

            if (this.options.displaySearchBox) {
                $(".dataTables_filter input", this.container).off();

                $(".dataTables_filter input", this.container).keypress(function (e) {
                    if (e.keyCode == 13) {
                        self._filterData();
                    }
                    return e.keyCode != 13;
                });

                $(".h-filterButton", this.container).on("click", function () {
                    self._filterData();
                });
            }

            if (this.options.advancedFilter) {
                $(".advanced-filter-toggle .button", this.container).on("click", function () {
                    $(this).toggleClass("selected");
                    $(this).find("span").toggleClass("filter filter-white");

                    $("tr.advanced-filter", self.container).toggle();

                    if (!$(this).hasClass("selected")) {
                        self._clearAdvancedFilter();
                    }
                });

                dataTable.on("keypress", ".advanced-filter-column :text", function (e) {
                    if (e.keyCode == 13) {
                        self._applyAdvancedFilter();
                    }
                    return e.keyCode != 13;
                });

                $(".h-applyAdvancedFilter", this.container).on("click", function () {
                    self._applyAdvancedFilter();
                });

                $(".h-clearAdvancedFilter", this.container).on("click", function () {
                    self._clearAdvancedFilter();
                });
            }
        },
        _applyAdvancedFilter: function () {
            this.dataTable.draw();
            this.advancedFilterApplied = true;
        },
        _clearAdvancedFilter: function () {
            $("tr.advanced-filter :input", this.container).val("");

            if (this.advancedFilterApplied) {
                this.dataTable.draw();
                this.advancedFilterApplied = false;
            }
        },
        _initializeSelectedRows: function () {
            var keyColumn = this.keyColumn;
            if (this.options.rememberRowSelection) {
                /* Modified from A4Survey */
                var inputContent = $(".lookup-variables", $(this.container).closest(".questionContent"));
                var keys = JSON.parse($("input[data-keys]", inputContent).val());
                this.options.selectedRows = _.map(keys, function (item) {
                    var row = {};
                    row[keyColumn] = item;
                    return row;
                });
                /* Modified from A4Survey */

                var selectedRows = this.options.selectedRows;
                if (selectedRows) {
                    if (_.isArray(selectedRows)) {
                        this.selectedRows = selectedRows;
                    }
                    else {
                        this.selectedRows = _.map(selectedRows.split(this.options.dataSplitChar), function (item) {
                            var row = {};
                            row[keyColumn] = item;
                            return row;
                        });
                    }
                }
                else {
                    this.selectedRows = [];
                }

                this._setSelectedRowsLabel();
            }
        },
        _updateSelectedRows: function (rowData, isChecked) {
            var keyColumn = this.keyColumn;
            var key = rowData[keyColumn];
            var self = this;

            if (this.options.rememberRowSelection && keyColumn) {
                if (isChecked) {
                    if (!_.some(this.selectedRows, function (item) { return item[keyColumn] == key; })) {
                        this.selectedRows.push(rowData);
                    }
                }
                else {
                    this.selectedRows = _.reject(this.selectedRows, function (item) { return item[keyColumn] == key; });
                }

                /* Modified from A4Survey */
                var inputContent = $(".lookup-variables", $(this.container).closest(".questionContent"));

                $("input:not([data-keys])", inputContent).each(function () {
                    var data = _.pluck(self.selectedRows, $(this).attr("data-column"));
                    $(this).val(JSON.stringify(data)).trigger("change");
                });

                $("input[data-keys]", inputContent).val(JSON.stringify(_.pluck(self.selectedRows, keyColumn))).trigger("change");
                /* Modified from A4Survey */
            }
        },
        _checkSelectedRowsLimit: function () {
            if (this.selectedRows && this.options.limitRowSelection) {
                if (this.selectedRows.length >= this.options.limitRowSelection) {
                    $("tr .selectRow:not(:checked)", this.container).prop("disabled", true);
                }
                else {
                    $("tr .selectRow", this.container).prop("disabled", false);
                }
            }
        },
        _setSelectedRowsLabel: function () {
            var label = "";

            if (this.selectedRows && this.selectedRows.length > 0) {
                if (this.options.limitRowSelection) {
                    label = this.selectedRows.length == 1 ? this._getLocalizableText("SelectedItemLimit") : this._getLocalizableText("SelectedItemsLimit");
                }
                else {
                    label = this.selectedRows.length == 1 ? this._getLocalizableText("SelectedItem") : this._getLocalizableText("SelectedItems");
                }

                label = "(" + label.replace(/{count}/g, this.selectedRows.length).replace(/{limit}/g, this.options.limitRowSelection) + ")";
            }

            $(".v-selectedRows", this.container).text(label);
        },
        _filterData: function () {
            var filterValue = $(".dataTables_filter input", this.container).val();
            this.dataTable.search(filterValue).draw();
        },
        _renderAdvancedFilterToggleButton: function () {
            if (this.options.advancedFilter) {
                var advancedFilterToggle = $("<div />", { "class": "button icon-only", "title": this._getLocalizableText("ToggleAdvancedFilter") }).append($("<span />", { "class": "icon filter" }));
                $(".advanced-filter-toggle", this.container).append(advancedFilterToggle);
            }
        },
        _renderColumnSelector: function () {
            if (this.options.displayColumnSelector) {
                var columnSelector = $("<div />", { "class": "button-group" });
                var self = this;

                columnSelector.append($("<div />", { "class": "button icon-only dropdown-toggle" }).append($("<span />", { "class": "icon columns" })).append($("<span />", { "class": "icon-small down-arrow-black" }))).addClass("button-group");

                var columns = $("<ul />", { "class": "dropdown-menu" });

                _.each(this.options.columns, function (item) {
                    if (item.Data && !item.HideInSelector) {
                        var checkbox = $("<input type='checkbox'>").prop("checked", self._isVisibleColumn(item));
                        columns.append($("<li />", { "data-column-name": item.Name }).append($("<a />", { "text": item.Title }).prepend(checkbox)));
                    }
                });

                columnSelector.append(columns);

                $(".column-selector", this.container).append(columnSelector);
            }
        },
        _getTableParams: function (aoData) {
            var data = {};

            if (aoData) {
                data.Echo = aoData.draw;
                data.PageStart = aoData.start;
                data.PageLength = aoData.length;

                if (aoData.search) {
                    data.Search = aoData.search.value;
                    data.IsSearch = data.Search != "";
                }

                if (aoData.order && aoData.order.length > 0) {
                    var column = aoData.columns[aoData.order[0].column];
                    data.SortColumn = column.name;
                    data.SortAscending = aoData.order[0].dir != "desc";
                    data.IsSort = true;
                }

                if (this.options.quickFilter && this.options.quickFilter.IncludeSelectedStates && ($(".v-selected.selected").length > 0 || $(".v-notSelected.selected").length > 0)) {
                    data.Selected = "'" + _.pluck(this.selectedRows, this.keyColumn).join("','") + "'";
                    data.ExcludeSelected = ($(".v-notSelected.selected").length > 0);
                }

                if (this.options.advancedFilter) {
                    data.AdvancedFilter = this._getTableAdvancedFilterParam();
                }
            }

            return data;
        },
        _getTableAdvancedFilterParam: function () {
            var self = this;
            var advancedFilterRow = $("tr.advanced-filter", this.container);
            var advancedFilter = [];

            if (advancedFilterRow.is(":visible")) {
                $(".advanced-filter-column[data-column]", advancedFilterRow).each(function () {
                    var column = self._getColumnByName($(this).attr("data-column"));

                    if (column.type == "date" || column.type == "datetime") {
                        var fromDate = $(this).find(".v-fromDate").val();
                        var toDate = $(this).find(".v-toDate").val();

                        if (fromDate || toDate) {
                            advancedFilter.push({ "Name": column.name, "Value": fromDate, "OtherValue": toDate, "Type": column.type });
                        }
                    }
                    else {
                        var value = $(this).find(":input").val();

                        if (value) {
                            advancedFilter.push({ "Name": column.name, "Value": value, "Type": column.type });
                        }
                    }
                });
            }

            return advancedFilter;
        },
        _setRowUpdated: function (row, rowData) {
            var self = this;

            if (self.keyColumn) {
                self.updatedRows = _.reject(self.updatedRows, function (item) { return item[self.keyColumn] == rowData[self.keyColumn] });
            }

            self.updatedRows.push(rowData);

            self._trigger("rowUpdated", null, { row: row, data: rowData });
        },
        _applyFilter: function (filterIndex) {
            var filter = this.options.quickFilter.Items[filterIndex];

            //Reset the params to what is specified by the user for the grid
            this.ajaxParams = _.clone(this.options.ajaxParams);

            //Merge grid params with filter params
            if (filter && filter.AjaxParams) {
                this.ajaxParams = _.extend(this.ajaxParams, filter.AjaxParams);
            }

            this.refresh(true);
        },
        refresh: function (resetPagination) {
            this.dataTable.draw(resetPagination);
        },
        getVisibleColumns: function (selectorOnly) {
            var columns;

            if (selectorOnly) {
                columns = $(".column-selector", this.container).find(":checkbox:checked").map(function () { return $(this).closest("li").attr("data-column-name"); }).get();
            }
            else {
                columns = $("thead th.value-column", this.container).map(function () { return $(this).attr("data-column-name"); }).get();
            }

            return columns;
        },
        toggleColumn: function (columnName, showOrHide) {
            var column = this.dataTable.column(columnName + ":name");

            if (showOrHide == undefined) {
                showOrHide = !column.visible();
            }

            column.visible(showOrHide);

            $(".column-selector li[data-column-name='" + columnName + "'] :checkbox", this.container).prop("checked", showOrHide);
        }
    });
}(jQuery));